<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"></xsl:import><xsl:import href="../../../../date.xsl"></xsl:import><xsl:import href="../../../../table.xsl"></xsl:import><xsl:import href="../../../../style.xsl"></xsl:import><xsl:import href="../../../../lien.xsl"></xsl:import><xsl:import href="../../../../commons/constants.xsl"></xsl:import><xsl:import href="../../../../commons/fonctions.xsl"></xsl:import><xsl:import href="../../../../commons/templates.xsl"></xsl:import><xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param><xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param><xsl:param name="p_33006_nature"></xsl:param><xsl:param name="p_33008_nature"></xsl:param><xsl:param name="p_33009_nature"></xsl:param><xsl:param name="p_33010_nature"></xsl:param><xsl:param name="p_33011_nature"></xsl:param><xsl:param name="p_33012_nature"></xsl:param><xsl:param name="p_33013_nature"></xsl:param><xsl:param name="p_33014_nature"></xsl:param><xsl:param name="p_32984_nature"></xsl:param><xsl:param name="p_32986_nature"></xsl:param><xsl:param name="p_33015_nature"></xsl:param><xsl:param name="p_33016_nature"></xsl:param><xsl:param name="p_33017_nature"></xsl:param><xsl:param name="p_33018_nature"></xsl:param><xsl:param name="p_33019_nature"></xsl:param><xsl:param name="p_33020_nature"></xsl:param><xsl:param name="p_32989_nature"></xsl:param><xsl:param name="p_32991_nature"></xsl:param><xsl:param name="p_33021_nature"></xsl:param><xsl:param name="p_32988_nature"></xsl:param><xsl:param name="p_32990_nature"></xsl:param><xsl:param name="p_33043_nature"></xsl:param><xsl:param name="p_32985_nature"></xsl:param><xsl:param name="p_32992_nature"></xsl:param><xsl:param name="p_32994_nature"></xsl:param><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="dcfu:CompteFinancierUnique"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
p.MsoFootnoteText, li.MsoFootnoteText, div.MsoFootnoteText
  {
  margin:0cm;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
span.MsoFootnoteReference
  {vertical-align:super;}
a:link, span.MsoHyperlink
  {color:blue;
  text-decoration:underline;}
a:visited, span.MsoHyperlinkFollowed
  {color:purple;
  text-decoration:underline;}
span.NotedebasdepageCar
  {
  
  font-family:"Times New Roman",serif;}
p.Contenudetableau, li.Contenudetableau, div.Contenudetableau
  {
  margin:0cm;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
span.Caractresdenotedebasdepage
  {}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style></head>
   <body lang="FR" link="blue" vlink="purple"><div id="header">
         <xsl:variable name="varOdmTmpTab1"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><tr><td width="75%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p style="punctuation-wrap:simple"><span style="font-size: 10.0pt;font-family:&#34;Arial&#34;,sans-serif">
                        <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@CodeBC)"/> – 
                        
                        
                        <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Libelle)"/></span></p></td><td width="25%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right;punctuation-wrap:simple"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">Exercice 
                        
                        
                        <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V)"/></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:4.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
      </div>
      
      <div class="WordSection1">
         <xsl:variable name="varOdmTmpTab2"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><xsl:choose><xsl:when test="$HTML_OUTPUT_FORMAT"><xsl:variable name="varOdm1" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><tr><td width="100%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                  <p class="MsoNormal"><span style="font-size:8.0pt"></span></p>
                  <xsl:variable name="varOdmTmpTab3"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="center" style="text-align:center;punctuation-wrap: simple">POSTE COMPTABLE : <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Tresorerie/@Codique)"/> <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Tresorerie/@LibellePoste)"/><xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:BudgetRattachement/@Libelle)"/></p></td></tr><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="center" style="text-align:center"><b><span style="font-size:14.0pt"><xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Libelle)"/></span></b></p></td></tr><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BA' or $docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BR'"><xsl:variable name="varOdm2" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="center" style="text-align:center;punctuation-wrap: simple">RELATIF AU BUDGET PRINCIPAL DE <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:BudgetRattachement/@Libelle)"/>
                              
                              
                           </p></td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="center" style="text-align:center;punctuation-wrap: simple"> </p><p align="center" style="text-align:center;punctuation-wrap: simple"><b>NOMENCLATURE : <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Nomenclature/@V)"/></b></p></td></tr><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="center" style="text-align:center;punctuation-wrap: simple"> </p><p align="center" style="text-align:center;punctuation-wrap: simple"><b>SIRET : <xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:with-param name="format" select="&quot;#0&quot;"/></xsl:call-template></b></p></td></tr><tr><td width="100%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td></tr><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:NatFonc/@V = '1' or $docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:NatFonc/@V = '3'"><xsl:variable name="varOdm3" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"><b> Voté par Nature</b></p>
                        </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding:0cm 5.4pt 0cm 5.4pt"></td></tr></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:NatFonc/@V = '2'"><xsl:variable name="varOdm4" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"><b> Voté par Fonction</b></p>
                        </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BP'"><xsl:variable name="varOdm5" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"> BUDGET PRINCIPAL</p>
                        </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BA' or $docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BR'"><xsl:variable name="varOdm6" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center">BUDGET ANNEXE</p>
                        </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param></xsl:call-template>
               </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:otherwise></xsl:choose></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" align="center" style="text-align:center"><b> </b></p>
         <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:14.0pt">Sommaire</span></b></p>
         <p class="MsoNormal"><span style="font-size:14.0pt"> </span></p>
         <xsl:variable name="varOdmTmpTab4"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><xsl:choose><xsl:when test="$HTML_OUTPUT_FORMAT"><xsl:variable name="varOdm7" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                  <p class="MsoNormal"><b><span style="font-size:8.0pt"></span></b></p>
                  <p class="MsoNormal" style="margin-top:0cm;margin-right:255.1pt;margin-bottom: 0cm;margin-left:255.1pt;margin-bottom:.0001pt"><span style="font-size:8.0pt"><span class="LIEN_ANCRE" onclick="scrollToElementId('CFU')">Le Compte Financier Unique</span></span></p>
                  <p class="MsoNormal" style="margin-top:0cm;margin-right:255.1pt;margin-bottom: 0cm;margin-left:255.1pt;margin-bottom:.0001pt"><span style="font-size:8.0pt"><span class="LIEN_ANCRE" onclick="scrollToElementId('BEC')">Balance et autres états comptables</span></span></p>
                  <p class="MsoNormal" style="margin-top:0cm;margin-right:255.1pt;margin-bottom: 0cm;margin-left:255.1pt;margin-bottom:.0001pt"><span style="font-size:8.0pt"><span class="LIEN_ANCRE" onclick="scrollToElementId('DB')">Liens vers les Documents Budgétaires</span></span></p>
                  <p class="MsoNormal" style="margin-top:0cm;margin-right:255.1pt;margin-bottom: 0cm;margin-left:255.1pt;margin-bottom:.0001pt"><span style="font-size:8.0pt"><span class="LIEN_ANCRE" onclick="scrollToElementId('ADD')">Autres documents dématérialisés</span></span></p>
               </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab4"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" align="center" style="text-align:center"><span style="font-size:12.0pt"><xsl:variable name ="Refer1">CFU</xsl:variable><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="$Refer1"/></xsl:call-template></span><span style="font-size:14.0pt">Le Compte Financier Unique</span></p>
         <p class="MsoNormal" align="center" style="text-align:center"> </p>
         <xsl:variable name="varOdmTmpTab5"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><xsl:choose><xsl:when test="$HTML_OUTPUT_FORMAT"><xsl:variable name="varOdm8" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt"></span></b></p>
                  <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt"> </span></b></p>
                  <xsl:variable name="varOdmTmpTab6"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><tr><xsl:variable name="varOdm9" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="55%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="35%" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="right" style="text-align:right"><span style="font-size:8.0pt"><xsl:variable name ="Link6">AARRESIG</xsl:variable><xsl:variable name ="Link7" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link8" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Page', ' ', 'de', ' ', 'signatures')" /><xsl:with-param name="Param_2" select="$Link6" /><xsl:with-param name="Param_3" select="$Link7" /><xsl:with-param name="Param_4" select="$Link8" /></xsl:call-template></span></p>
                        </td></tr><tr><xsl:variable name="varOdm10" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="55%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="35%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt"><xsl:variable name ="Link9">ETACTRLCPTFIN</xsl:variable><xsl:variable name ="Link10" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link11" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="'ECCF'" /><xsl:with-param name="Param_2" select="$Link9" /><xsl:with-param name="Param_3" select="$Link10" /><xsl:with-param name="Param_4" select="$Link11" /></xsl:call-template></span></p>
                        </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab6"></xsl:with-param></xsl:call-template>
                  <xsl:variable name="varOdmTmpTab7"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><thead>
                        <tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                              <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">Origine des données</span></p>
                           </td></tr>
                     </thead><tr><td width="10%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt;color:black">I. Informations générales et synthétiques</span></b></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm11" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link12">AINFOSTATFISCFIN</xsl:variable><xsl:variable name ="Link13" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link14" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Informations', ' ', 'statistiques,', ' ', 'fiscales', ' ', 'et', ' ', 'financières')" /><xsl:with-param name="Param_2" select="$Link12" /><xsl:with-param name="Param_3" select="$Link13" /><xsl:with-param name="Param_4" select="$Link14" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm12" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link15">B1PRESCPTFIN</xsl:variable><xsl:variable name ="Link16" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link17" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Présentation', ' ', 'générale', ' ', 'du', ' ', 'compte', ' ', 'financier', ' ', '-', ' ', 'Vue', ' ', 'd&#146;ensemble')" /><xsl:with-param name="Param_2" select="$Link15" /><xsl:with-param name="Param_3" select="$Link16" /><xsl:with-param name="Param_4" select="$Link17" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm13" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link18">BRESCUMUL</xsl:variable><xsl:variable name ="Link19" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link20" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Détermination', ' ', 'du', ' ', 'résultat', ' ', 'cumulé', ' ', 'à', ' ', 'la', ' ', 'fin', ' ', 'de', ' ', 'l&#146;exercice')" /><xsl:with-param name="Param_2" select="$Link18" /><xsl:with-param name="Param_3" select="$Link19" /><xsl:with-param name="Param_4" select="$Link20" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm14" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">B3.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link21">B31ORGAREGROUP</xsl:variable><xsl:variable name ="Link22" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link23" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Liste', ' ', 'des', ' ', 'organismes', ' ', 'de', ' ', 'regroupement')" /><xsl:with-param name="Param_2" select="$Link21" /><xsl:with-param name="Param_3" select="$Link22" /><xsl:with-param name="Param_4" select="$Link23" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm15" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">B3.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link24">B32ETAPUB</xsl:variable><xsl:variable name ="Link25" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link26" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Liste', ' ', 'des', ' ', 'établissements', ' ', 'publics', ' ', 'créés')" /><xsl:with-param name="Param_2" select="$Link24" /><xsl:with-param name="Param_3" select="$Link25" /><xsl:with-param name="Param_4" select="$Link26" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm16" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">B3.3</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link27">B33SERVINDIV</xsl:variable><xsl:variable name ="Link28" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link29" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Liste', ' ', 'des', ' ', 'services', ' ', 'individualisés', ' ', 'dans', ' ', 'un', ' ', 'budget', ' ', 'annexe')" /><xsl:with-param name="Param_2" select="$Link27" /><xsl:with-param name="Param_3" select="$Link28" /><xsl:with-param name="Param_4" select="$Link29" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm17" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link30">C1RESTREALDEP</xsl:variable><xsl:variable name ="Link31" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link32" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Détail', ' ', 'des', ' ', 'restes', ' ', 'à', ' ', 'réaliser', ' ', '-', ' ', 'Dépenses')" /><xsl:with-param name="Param_2" select="$Link30" /><xsl:with-param name="Param_3" select="$Link31" /><xsl:with-param name="Param_4" select="$Link32" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm18" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link33">C2RESTREALREC</xsl:variable><xsl:variable name ="Link34" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link35" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Détail', ' ', 'des', ' ', 'restes', ' ', 'à', ' ', 'réaliser', ' ', '-', ' ', 'Recettes')" /><xsl:with-param name="Param_2" select="$Link33" /><xsl:with-param name="Param_3" select="$Link34" /><xsl:with-param name="Param_4" select="$Link35" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm19" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link36">DBILANSYNTH</xsl:variable><xsl:variable name ="Link37" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link38" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Bilan', ' ', 'Synthétique')" /><xsl:with-param name="Param_2" select="$Link36" /><xsl:with-param name="Param_3" select="$Link37" /><xsl:with-param name="Param_4" select="$Link38" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td></tr><tr><xsl:variable name="varOdm20" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">E</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link39">ECPTRESSYNTH</xsl:variable><xsl:variable name ="Link40" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link41" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Compte', ' ', 'de', ' ', 'résultat', ' ', 'synthétique')" /><xsl:with-param name="Param_2" select="$Link39" /><xsl:with-param name="Param_3" select="$Link40" /><xsl:with-param name="Param_4" select="$Link41" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td></tr><tr><xsl:variable name="varOdm21" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">F</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link42">FTAUXCTRPROD</xsl:variable><xsl:variable name ="Link43" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link44" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Taux', ' ', 'des', ' ', 'contributions', ' ', 'et', ' ', 'produits', ' ', 'afférents', ' ', 'en', ' ', 'N')" /><xsl:with-param name="Param_2" select="$Link42" /><xsl:with-param name="Param_3" select="$Link43" /><xsl:with-param name="Param_4" select="$Link44" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt;color:black">II. Exécution budgétaire</span></b></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm22" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link45">AVOTEBUDG</xsl:variable><xsl:variable name ="Link46" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link47" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Modalités', ' ', 'de', ' ', 'vote', ' ', 'du', ' ', 'budget')" /><xsl:with-param name="Param_2" select="$Link45" /><xsl:with-param name="Param_3" select="$Link46" /><xsl:with-param name="Param_4" select="$Link47" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">Vue d'ensemble</span></i></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm23" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A1.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link48">A11DEPINV</xsl:variable><xsl:variable name ="Link49" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link50" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Dépenses', ' ', 'd&#146;investissement')" /><xsl:with-param name="Param_2" select="$Link48" /><xsl:with-param name="Param_3" select="$Link49" /><xsl:with-param name="Param_4" select="$Link50" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm24" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A1.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link51">A12RECINV</xsl:variable><xsl:variable name ="Link52" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link53" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Recette', ' ', 'd&#146;investissement')" /><xsl:with-param name="Param_2" select="$Link51" /><xsl:with-param name="Param_3" select="$Link52" /><xsl:with-param name="Param_4" select="$Link53" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm25" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A2.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link54">A21DEPFONC</xsl:variable><xsl:variable name ="Link55" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link56" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Dépenses', ' ', 'de', ' ', 'fonctionnement')" /><xsl:with-param name="Param_2" select="$Link54" /><xsl:with-param name="Param_3" select="$Link55" /><xsl:with-param name="Param_4" select="$Link56" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm26" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A2.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link57">A22RECFONC</xsl:variable><xsl:variable name ="Link58" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link59" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Recettes', ' ', 'de', ' ', 'fonctionnement')" /><xsl:with-param name="Param_2" select="$Link57" /><xsl:with-param name="Param_3" select="$Link58" /><xsl:with-param name="Param_4" select="$Link59" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">Vue détaillée</span></i></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm27" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link60">B1DEPINV</xsl:variable><xsl:variable name ="Link61" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link62" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Dépenses', ' ', 'd&#146;investissement')" /><xsl:with-param name="Param_2" select="$Link60" /><xsl:with-param name="Param_3" select="$Link61" /><xsl:with-param name="Param_4" select="$Link62" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td></tr><tr><xsl:variable name="varOdm28" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link63">B2RECINV</xsl:variable><xsl:variable name ="Link64" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link65" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Recettes', ' ', 'd&#146;investissement')" /><xsl:with-param name="Param_2" select="$Link63" /><xsl:with-param name="Param_3" select="$Link64" /><xsl:with-param name="Param_4" select="$Link65" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td></tr><tr><xsl:variable name="varOdm29" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link66">C1OPEREQUIP</xsl:variable><xsl:variable name ="Link67" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link68" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Opérations', ' ', 'd&#146;équipement', ' ', '-', ' ', 'Détail', ' ', 'des', ' ', 'chapitres', ' ', 'et', ' ', 'articles')" /><xsl:with-param name="Param_2" select="$Link66" /><xsl:with-param name="Param_3" select="$Link67" /><xsl:with-param name="Param_4" select="$Link68" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm30" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link69">D1DEPFONC</xsl:variable><xsl:variable name ="Link70" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link71" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Dépenses', ' ', 'de', ' ', 'fonctionnement')" /><xsl:with-param name="Param_2" select="$Link69" /><xsl:with-param name="Param_3" select="$Link70" /><xsl:with-param name="Param_4" select="$Link71" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td></tr><tr><xsl:variable name="varOdm31" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link72">D2RECFONC</xsl:variable><xsl:variable name ="Link73" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link74" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Recettes', ' ', 'de', ' ', 'fonctionnement')" /><xsl:with-param name="Param_2" select="$Link72" /><xsl:with-param name="Param_3" select="$Link73" /><xsl:with-param name="Param_4" select="$Link74" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td></tr><tr><td width="10%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt;color:black">III. États Financiers</span></b></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm32" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link75">ABILAN</xsl:variable><xsl:variable name ="Link76" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link77" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="'Bilan'" /><xsl:with-param name="Param_2" select="$Link75" /><xsl:with-param name="Param_3" select="$Link76" /><xsl:with-param name="Param_4" select="$Link77" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td></tr><tr><xsl:variable name="varOdm33" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link78">BCPTRES</xsl:variable><xsl:variable name ="Link79" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link80" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Compte', ' ', 'de', ' ', 'résultat')" /><xsl:with-param name="Param_2" select="$Link78" /><xsl:with-param name="Param_3" select="$Link79" /><xsl:with-param name="Param_4" select="$Link80" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td></tr><tr><xsl:variable name="varOdm34" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link81">CANNEX</xsl:variable><xsl:variable name ="Link82" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link83" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Annexe', ' ', '(uniquement', ' ', 'pour', ' ', 'les', ' ', 'collectivités', ' ', 'certifiables)')" /><xsl:with-param name="Param_2" select="$Link81" /><xsl:with-param name="Param_3" select="$Link82" /><xsl:with-param name="Param_4" select="$Link83" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur / Comptable - Pièce jointe</span></p>
                        </td></tr><tr><td width="10%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><u><span style="font-size:8.0pt;color:blue">IV. États annexés</span></u></b></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="10%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">A. Présentation croisée et agrégée</span></i></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Présentation croisée, section d’investissement – vue d’ensemble</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Présentation croisée, section de fonctionnement – vue d’ensemble</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A3</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Présentation agrégée du budget principal et des budgets annexes</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">B. États annexés patrimoniaux</span></i></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Détail des crédits de trésorerie</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Répartition par nature de dette</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.3</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Répartition par structure de taux</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.4</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Typologie de la répartition de l'encours</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.5</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Détail des opérations de couverture</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.6</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Remboursement anticipé d'un emprunt avec refinancement</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.7</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Emprunts renégociés au cours de l'année N</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.8</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Dette pour financer l'emprunt d'un autre organisme</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.9</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Autres dettes</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Méthodes utilisées pour les amortissements</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B3.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des provisions</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B3.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Étalement des provisions</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B4</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des charges transférées</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B5</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Détail des opérations pour le compte de tiers</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B6</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Prêts</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B7.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des emprunts garantis</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B7.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Calcul du ratio d'endettement relatif aux emprunts garantis</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.1.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Liste des concours attribués à des tiers en nature ou en subventions</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.1.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Liste des subventions versées aux communes</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des contrats de crédit-bail</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.3</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des contrats de partenariat public-privé</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.4</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des autres engagements donnés</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.5</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des engagements reçus</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B9</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État du personnel</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B10</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Liste des organismes dans lesquels la collectivité a pris un engagement financier</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B12.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Variation du patrimoine – Entrées</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B12.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Variation du patrimoine – Sorties</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" style="layout-grid-mode:char"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B13</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Opérations liées aux cessions</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B14</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des travaux en régie</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">C. États annexés budgétaires</span></i></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Équilibre budgétaire - dépenses</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Équilibre budgétaire - recettes</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C2.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Situation des autorisations de programme</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C2.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Situation des autorisations d’engagement</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">D. Autres éléments d’information</span></i></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des recettes grevées d'une affectation spéciale</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D2.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt;color:black">Liste des services assujettis à la TVA et non érigés en budget annexe</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D2.2.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt;color:black">Services assujettis à la TVA – vue d’ensemble</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D3.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Services ferroviaires régionaux des voyageurs (SRV) - Volet 1 : Budget</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D3.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">SRV - Volet 2 : Compte d'exploitation</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D3.3</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">SRV - Volet 3 : Patrimoine</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D4.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Variation du patrimoine (article L. 300-5 du code de l'urbanisme) – Entrées</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D4.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Variation du patrimoine (article L. 300-5 du code de l'urbanisme) – Sorties</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D5</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Gestion des fonds européens</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D6</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Emploi des crédits communautaires dans le cadre de la subvention globale</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D7</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Actions de formation des élus</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D8</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État relatif aux ressources et dépenses de la formation professionnelle des jeunes</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D9</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Compte d'emploi du fonds commun des services d'hébergement</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D10</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Identification des flux croisés</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D11.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt;color:black">États de la répartition de la TEOM – investissement</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D11.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt;color:black">États de la répartition de la TEOM – fonctionnement</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt;color:black">V. Arrêté et signatures</span></b></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm35" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link84">AARRESIG</xsl:variable><xsl:variable name ="Link85" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link86" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Arrêté', ' ', 'et', ' ', 'signatures')" /><xsl:with-param name="Param_2" select="$Link84" /><xsl:with-param name="Param_3" select="$Link85" /><xsl:with-param name="Param_4" select="$Link86" /></xsl:call-template></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur / Comptable</span></p>
                        </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab7"></xsl:with-param></xsl:call-template>
                  <p class="MsoNormal" align="center" style="text-align:center"><span style="font-size:12.0pt"> </span></p>
                  <p class="MsoNormal" align="center" style="text-align:center;page-break-after: avoid;punctuation-wrap:simple"><span style="font-size:12.0pt"><xsl:variable name ="Refer2">BEC</xsl:variable><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="$Refer2"/></xsl:call-template>Balance et autres états comptables</span></p>
                  <p class="MsoNormal" style="page-break-after:avoid;punctuation-wrap:simple"><span style="font-size:12.0pt"> </span></p>
                  <xsl:variable name="varOdmTmpTab8"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><tr><xsl:variable name="varOdm36" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link87">BALGENCPT</xsl:variable><xsl:variable name ="Link88" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link89" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Balance', ' ', 'Générale', ' ', 'des', ' ', 'comptes')" /><xsl:with-param name="Param_2" select="$Link87" /><xsl:with-param name="Param_3" select="$Link88" /><xsl:with-param name="Param_4" select="$Link89" /></xsl:call-template></span></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm37" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link90">BALVALIN</xsl:variable><xsl:variable name ="Link91" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link92" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Balance', ' ', 'des', ' ', 'Valeurs', ' ', 'Inactives')" /><xsl:with-param name="Param_2" select="$Link90" /><xsl:with-param name="Param_3" select="$Link91" /><xsl:with-param name="Param_4" select="$Link92" /></xsl:call-template></span></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm38" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link93">ETATRAR</xsl:variable><xsl:variable name ="Link94" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link95" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('État', ' ', 'de', ' ', 'solde', ' ', ':', ' ', 'Reste', ' ', 'A', ' ', 'Recouvrer')" /><xsl:with-param name="Param_2" select="$Link93" /><xsl:with-param name="Param_3" select="$Link94" /><xsl:with-param name="Param_4" select="$Link95" /></xsl:call-template></span></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm39" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link96">ETATRAP</xsl:variable><xsl:variable name ="Link97" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link98" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('État', ' ', 'de', ' ', 'solde', ' ', ':', ' ', 'Reste', ' ', 'A', ' ', 'Payer')" /><xsl:with-param name="Param_2" select="$Link96" /><xsl:with-param name="Param_3" select="$Link97" /><xsl:with-param name="Param_4" select="$Link98" /></xsl:call-template></span></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm40" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link99">ETATEDDS</xsl:variable><xsl:variable name ="Link100" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link101" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('État', ' ', 'de', ' ', 'Développement', ' ', 'Des', ' ', 'Soldes', ' ', 'EDDS')" /><xsl:with-param name="Param_2" select="$Link99" /><xsl:with-param name="Param_3" select="$Link100" /><xsl:with-param name="Param_4" select="$Link101" /></xsl:call-template></span></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm41" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link102">ETATFB</xsl:variable><xsl:variable name ="Link103" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link104" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Fiches', ' ', 'Budgétaires')" /><xsl:with-param name="Param_2" select="$Link102" /><xsl:with-param name="Param_3" select="$Link103" /><xsl:with-param name="Param_4" select="$Link104" /></xsl:call-template></span></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm42" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link105">ETATLACTF</xsl:variable><xsl:variable name ="Link106" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link107" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Livre', ' ', 'Auxiliaire', ' ', 'des', ' ', 'Comptes', ' ', 'de', ' ', 'Tiers', ' ', 'et', ' ', 'des', ' ', 'comptes', ' ', 'Financiers')" /><xsl:with-param name="Param_2" select="$Link105" /><xsl:with-param name="Param_3" select="$Link106" /><xsl:with-param name="Param_4" select="$Link107" /></xsl:call-template></span></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm43" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link108">ETATOPC</xsl:variable><xsl:variable name ="Link109" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link110" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('État', ' ', 'des', ' ', 'ordres', ' ', 'de', ' ', 'paiement')" /><xsl:with-param name="Param_2" select="$Link108" /><xsl:with-param name="Param_3" select="$Link109" /><xsl:with-param name="Param_4" select="$Link110" /></xsl:call-template></span></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab8"></xsl:with-param></xsl:call-template>
                  <p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size: 12.0pt"> </span></p>
                  <p class="MsoNormal" align="center" style="text-align:center;page-break-after: avoid;punctuation-wrap:simple"><span style="font-size:12.0pt"><xsl:variable name ="Refer3">DB</xsl:variable><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="$Refer3"/></xsl:call-template>Liens vers les Documents Budgétaires</span></p>
                  <p class="MsoNormal" style="page-break-after:avoid;punctuation-wrap:simple"><span style="font-size:12.0pt"> </span></p>
                  <xsl:variable name="varOdmTmpTab9"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="background:#E6E6E6;padding: 0cm 1.4pt 1.5pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" style="margin-top:2.85pt;margin-right:0cm; margin-bottom:2.85pt;margin-left:0cm"><b><span style="font-size:8.0pt; color:black">Budgets (BP et BS)</span></b></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="MsoNormal" style="punctuation-wrap:simple"><u><span style="font-size:8.0pt;color:blue">[libellé doc bud] [identifiant doc bud]</span></u></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="MsoNormal" style="punctuation-wrap:simple"><u><span style="font-size:8.0pt;color:blue">[libellé doc bud] [identifiant doc bud]</span></u></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="MsoNormal" style="punctuation-wrap:simple"><i><span style="font-size:8.0pt">etc.</span></i></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="background:#E6E6E6;padding: 0cm 1.4pt 1.5pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="MsoNormal" style="margin-top:2.85pt;margin-right:0cm;margin-bottom: 2.85pt;margin-left:0cm;punctuation-wrap:simple"><b><span style="font-size: 8.0pt;color:black">Décision(s) Modificative(s)</span></b></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size: 8.0pt">Numéro de la décision : <u><span style="color:blue">[num décision] : [libellé doc bud] [identifiant doc bud]</span></u></span></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size: 8.0pt">Numéro de la décision : <u><span style="color:blue">[num décision] : [libellé doc bud] [identifiant doc bud]</span></u></span></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="MsoNormal" style="punctuation-wrap:simple"><i><span style="font-size:8.0pt">etc.</span></i></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab9"></xsl:with-param></xsl:call-template>
                  <p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size: 12.0pt"> </span></p>
                  <p class="MsoNormal" align="center" style="text-align:center;page-break-after: avoid;punctuation-wrap:simple"><span style="font-size:12.0pt"><xsl:variable name ="Refer4">ADD</xsl:variable><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="$Refer4"/></xsl:call-template>Autres documents dématérialisés</span></p>
                  <p class="MsoNormal" style="page-break-after:avoid;punctuation-wrap:simple"><span style="font-size:12.0pt"> </span></p>
                  <xsl:variable name="varOdmTmpTab10"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><tr><xsl:variable name="varOdm44" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link111">LISTORMC</xsl:variable><xsl:variable name ="Link112" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link113" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="'ORMC'" /><xsl:with-param name="Param_2" select="$Link111" /><xsl:with-param name="Param_3" select="$Link112" /><xsl:with-param name="Param_4" select="$Link113" /></xsl:call-template></span></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab10"></xsl:with-param></xsl:call-template>
               </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab5"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" align="center" style="text-align:center;punctuation-wrap:simple"><span style="font-size:4.0pt"> </span></p>
         <xsl:variable name="varOdmTmpTab11"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><xsl:choose><xsl:when test="$PDF_OUTPUT_FORMAT"><xsl:variable name="varOdm45" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt"></span></b></p>
                  <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt"> </span></b></p>
                  <xsl:variable name="varOdmTmpTab12"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><tr><xsl:variable name="varOdm46" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td><td width="55%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td><td width="25%" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="right" style="text-align:right"><span style="font-size:8.0pt"><xsl:variable name ="Link114">AARRESIG</xsl:variable><xsl:variable name ="Link115" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link116" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Arrêté', ' ', 'et', ' ', 'signatures')" /><xsl:with-param name="Param_2" select="$Link114" /><xsl:with-param name="Param_3" select="$Link115" /><xsl:with-param name="Param_4" select="$Link116" /></xsl:call-template></span></p>
                        </td><td width="10%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm47" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td><td width="55%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td><td width="25%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt"><xsl:variable name ="Link117">ETACTRLCPTFIN</xsl:variable><xsl:variable name ="Link118" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link119" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="'ECCF'" /><xsl:with-param name="Param_2" select="$Link117" /><xsl:with-param name="Param_3" select="$Link118" /><xsl:with-param name="Param_4" select="$Link119" /></xsl:call-template></span></p>
                        </td><td width="10%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab12"></xsl:with-param></xsl:call-template>
                  <xsl:variable name="varOdmTmpTab13"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><thead>
                        <tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                              <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">Origine des données</span></p>
                           </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                              <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">Page</span></p>
                           </td></tr>
                     </thead><tr><td width="9.3%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt;color:black">I. Informations générales et synthétiques</span></b></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm48" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link120">AINFOSTATFISCFIN</xsl:variable><xsl:variable name ="Link121" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link122" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Informations', ' ', 'statistiques,', ' ', 'fiscales', ' ', 'et', ' ', 'financières')" /><xsl:with-param name="Param_2" select="$Link120" /><xsl:with-param name="Param_3" select="$Link121" /><xsl:with-param name="Param_4" select="$Link122" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33006_nature &gt; 0"><xsl:value-of select="$p_33006_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm49" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link123">B1PRESCPTFIN</xsl:variable><xsl:variable name ="Link124" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link125" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Présentation', ' ', 'générale', ' ', 'du', ' ', 'compte', ' ', 'financier', ' ', '-', ' ', 'Vue', ' ', 'd&#146;ensemble')" /><xsl:with-param name="Param_2" select="$Link123" /><xsl:with-param name="Param_3" select="$Link124" /><xsl:with-param name="Param_4" select="$Link125" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33008_nature &gt; 0"><xsl:value-of select="$p_33008_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm50" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link126">BRESCUMUL</xsl:variable><xsl:variable name ="Link127" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link128" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Détermination', ' ', 'du', ' ', 'résultat', ' ', 'cumulé', ' ', 'à', ' ', 'la', ' ', 'fin', ' ', 'de', ' ', 'l&#146;exercice')" /><xsl:with-param name="Param_2" select="$Link126" /><xsl:with-param name="Param_3" select="$Link127" /><xsl:with-param name="Param_4" select="$Link128" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33009_nature &gt; 0"><xsl:value-of select="$p_33009_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm51" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">B3.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link129">B31ORGAREGROUP</xsl:variable><xsl:variable name ="Link130" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link131" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Liste', ' ', 'des', ' ', 'organismes', ' ', 'de', ' ', 'regroupement')" /><xsl:with-param name="Param_2" select="$Link129" /><xsl:with-param name="Param_3" select="$Link130" /><xsl:with-param name="Param_4" select="$Link131" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33010_nature &gt; 0"><xsl:value-of select="$p_33010_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm52" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">B3.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link132">B32ETAPUB</xsl:variable><xsl:variable name ="Link133" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link134" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Liste', ' ', 'des', ' ', 'établissements', ' ', 'publics', ' ', 'créés')" /><xsl:with-param name="Param_2" select="$Link132" /><xsl:with-param name="Param_3" select="$Link133" /><xsl:with-param name="Param_4" select="$Link134" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33011_nature &gt; 0"><xsl:value-of select="$p_33011_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm53" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">B3.3</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link135">B33SERVINDIV</xsl:variable><xsl:variable name ="Link136" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link137" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Liste', ' ', 'des', ' ', 'services', ' ', 'individualisés', ' ', 'dans', ' ', 'un', ' ', 'budget', ' ', 'annexe')" /><xsl:with-param name="Param_2" select="$Link135" /><xsl:with-param name="Param_3" select="$Link136" /><xsl:with-param name="Param_4" select="$Link137" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33012_nature &gt; 0"><xsl:value-of select="$p_33012_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm54" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link138">C1RESTREALDEP</xsl:variable><xsl:variable name ="Link139" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link140" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Détail', ' ', 'des', ' ', 'restes', ' ', 'à', ' ', 'réaliser', ' ', '-', ' ', 'Dépenses')" /><xsl:with-param name="Param_2" select="$Link138" /><xsl:with-param name="Param_3" select="$Link139" /><xsl:with-param name="Param_4" select="$Link140" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33013_nature &gt; 0"><xsl:value-of select="$p_33013_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm55" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link141">C2RESTREALREC</xsl:variable><xsl:variable name ="Link142" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link143" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Détail', ' ', 'des', ' ', 'restes', ' ', 'à', ' ', 'réaliser', ' ', '-', ' ', 'Recettes')" /><xsl:with-param name="Param_2" select="$Link141" /><xsl:with-param name="Param_3" select="$Link142" /><xsl:with-param name="Param_4" select="$Link143" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33014_nature &gt; 0"><xsl:value-of select="$p_33014_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm56" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link144">DBILANSYNTH</xsl:variable><xsl:variable name ="Link145" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link146" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Bilan', ' ', 'Synthétique')" /><xsl:with-param name="Param_2" select="$Link144" /><xsl:with-param name="Param_3" select="$Link145" /><xsl:with-param name="Param_4" select="$Link146" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_32984_nature &gt; 0"><xsl:value-of select="$p_32984_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm57" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">E</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link147">ECPTRESSYNTH</xsl:variable><xsl:variable name ="Link148" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link149" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Compte', ' ', 'de', ' ', 'résultat', ' ', 'synthétique')" /><xsl:with-param name="Param_2" select="$Link147" /><xsl:with-param name="Param_3" select="$Link148" /><xsl:with-param name="Param_4" select="$Link149" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_32986_nature &gt; 0"><xsl:value-of select="$p_32986_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm58" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">F</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link150">FTAUXCTRPROD</xsl:variable><xsl:variable name ="Link151" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link152" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Taux', ' ', 'des', ' ', 'contributions', ' ', 'et', ' ', 'produits', ' ', 'afférents', ' ', 'en', ' ', 'N')" /><xsl:with-param name="Param_2" select="$Link150" /><xsl:with-param name="Param_3" select="$Link151" /><xsl:with-param name="Param_4" select="$Link152" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33015_nature &gt; 0"><xsl:value-of select="$p_33015_nature" /></xsl:if></span></p>
                        </td></tr><tr><td width="9.3%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt;color:black">II. Exécution budgétaire</span></b></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm59" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link153">AVOTEBUDG</xsl:variable><xsl:variable name ="Link154" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link155" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Modalités', ' ', 'de', ' ', 'vote', ' ', 'du', ' ', 'budget')" /><xsl:with-param name="Param_2" select="$Link153" /><xsl:with-param name="Param_3" select="$Link154" /><xsl:with-param name="Param_4" select="$Link155" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33016_nature &gt; 0"><xsl:value-of select="$p_33016_nature" /></xsl:if></span></p>
                        </td></tr><tr><td width="9.3%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">Vue d'ensemble</span></i></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm60" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A1.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link156">A11DEPINV</xsl:variable><xsl:variable name ="Link157" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link158" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Dépenses', ' ', 'd&#146;investissement')" /><xsl:with-param name="Param_2" select="$Link156" /><xsl:with-param name="Param_3" select="$Link157" /><xsl:with-param name="Param_4" select="$Link158" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33017_nature &gt; 0"><xsl:value-of select="$p_33017_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm61" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A1.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link159">A12RECINV</xsl:variable><xsl:variable name ="Link160" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link161" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Recette', ' ', 'd&#146;investissement')" /><xsl:with-param name="Param_2" select="$Link159" /><xsl:with-param name="Param_3" select="$Link160" /><xsl:with-param name="Param_4" select="$Link161" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33018_nature &gt; 0"><xsl:value-of select="$p_33018_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm62" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A2.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link162">A21DEPFONC</xsl:variable><xsl:variable name ="Link163" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link164" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Dépenses', ' ', 'de', ' ', 'fonctionnement')" /><xsl:with-param name="Param_2" select="$Link162" /><xsl:with-param name="Param_3" select="$Link163" /><xsl:with-param name="Param_4" select="$Link164" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33019_nature &gt; 0"><xsl:value-of select="$p_33019_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm63" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A2.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link165">A22RECFONC</xsl:variable><xsl:variable name ="Link166" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link167" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Recettes', ' ', 'de', ' ', 'fonctionnement')" /><xsl:with-param name="Param_2" select="$Link165" /><xsl:with-param name="Param_3" select="$Link166" /><xsl:with-param name="Param_4" select="$Link167" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33020_nature &gt; 0"><xsl:value-of select="$p_33020_nature" /></xsl:if></span></p>
                        </td></tr><tr><td width="9.3%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">Vue détaillée</span></i></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm64" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link168">B1DEPINV</xsl:variable><xsl:variable name ="Link169" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link170" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Dépenses', ' ', 'd&#146;investissement')" /><xsl:with-param name="Param_2" select="$Link168" /><xsl:with-param name="Param_3" select="$Link169" /><xsl:with-param name="Param_4" select="$Link170" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_32989_nature &gt; 0"><xsl:value-of select="$p_32989_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm65" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link171">B2RECINV</xsl:variable><xsl:variable name ="Link172" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link173" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Recettes', ' ', 'd&#146;investissement')" /><xsl:with-param name="Param_2" select="$Link171" /><xsl:with-param name="Param_3" select="$Link172" /><xsl:with-param name="Param_4" select="$Link173" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_32991_nature &gt; 0"><xsl:value-of select="$p_32991_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm66" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link174">C1OPEREQUIP</xsl:variable><xsl:variable name ="Link175" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link176" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Opérations', ' ', 'd&#146;équipement', ' ', '-', ' ', 'Détail', ' ', 'des', ' ', 'chapitres', ' ', 'et', ' ', 'articles')" /><xsl:with-param name="Param_2" select="$Link174" /><xsl:with-param name="Param_3" select="$Link175" /><xsl:with-param name="Param_4" select="$Link176" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33021_nature &gt; 0"><xsl:value-of select="$p_33021_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm67" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link177">D1DEPFONC</xsl:variable><xsl:variable name ="Link178" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link179" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Dépenses', ' ', 'de', ' ', 'fonctionnement')" /><xsl:with-param name="Param_2" select="$Link177" /><xsl:with-param name="Param_3" select="$Link178" /><xsl:with-param name="Param_4" select="$Link179" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_32988_nature &gt; 0"><xsl:value-of select="$p_32988_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm68" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link180">D2RECFONC</xsl:variable><xsl:variable name ="Link181" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link182" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Recettes', ' ', 'de', ' ', 'fonctionnement')" /><xsl:with-param name="Param_2" select="$Link180" /><xsl:with-param name="Param_3" select="$Link181" /><xsl:with-param name="Param_4" select="$Link182" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_32990_nature &gt; 0"><xsl:value-of select="$p_32990_nature" /></xsl:if></span></p>
                        </td></tr><tr><td width="9.3%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt;color:black">III. États Financiers</span></b></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm69" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link183">ABILAN</xsl:variable><xsl:variable name ="Link184" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link185" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="'Bilan'" /><xsl:with-param name="Param_2" select="$Link183" /><xsl:with-param name="Param_3" select="$Link184" /><xsl:with-param name="Param_4" select="$Link185" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33043_nature &gt; 0"><xsl:value-of select="$p_33043_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm70" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link186">BCPTRES</xsl:variable><xsl:variable name ="Link187" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link188" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Compte', ' ', 'de', ' ', 'résultat')" /><xsl:with-param name="Param_2" select="$Link186" /><xsl:with-param name="Param_3" select="$Link187" /><xsl:with-param name="Param_4" select="$Link188" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_32985_nature &gt; 0"><xsl:value-of select="$p_32985_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm71" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link189">CANNEX</xsl:variable><xsl:variable name ="Link190" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link191" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Annexe', ' ', '(uniquement', ' ', 'pour', ' ', 'les', ' ', 'collectivités', ' ', 'certifiables)')" /><xsl:with-param name="Param_2" select="$Link189" /><xsl:with-param name="Param_3" select="$Link190" /><xsl:with-param name="Param_4" select="$Link191" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur / Comptable - Pièce jointe</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_32992_nature &gt; 0"><xsl:value-of select="$p_32992_nature" /></xsl:if></span></p>
                        </td></tr><tr><td width="9.3%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt;color:black">IV. États annexés</span></b></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">A. Présentation croisée et agrégée</span></i></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Présentation croisée, section d’investissement – vue d’ensemble</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Présentation croisée, section de fonctionnement – vue d’ensemble</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A3</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Présentation agrégée du budget principal et des budgets annexes</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">B. États annexés patrimoniaux</span></i></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Détail des crédits de trésorerie</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Répartition par nature de dette</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.3</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Répartition par structure de taux</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.4</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Typologie de la répartition de l'encours</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.5</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Détail des opérations de couverture</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.6</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Remboursement anticipé d'un emprunt avec refinancement</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.7</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Emprunts renégociés au cours de l'année N</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.8</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Dette pour financer l'emprunt d'un autre organisme</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.9</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Autres dettes</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Méthodes utilisées pour les amortissements</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B3.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des provisions</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B3.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Étalement des provisions</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B4</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des charges transférées</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B5</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Détail des opérations pour le compte de tiers</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B6</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Prêts</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B7.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des emprunts garantis</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B7.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Calcul du ratio d'endettement relatif aux emprunts garantis</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.1.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Liste des concours attribués à des tiers en nature ou en subventions</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.1.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Liste des subventions versées aux communes</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des contrats de crédit-bail</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.3</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des contrats de partenariat public-privé</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.4</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des autres engagements donnés</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.5</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des engagements reçus</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B9</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État du personnel</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B10</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Liste des organismes dans lesquels la collectivité a pris un engagement financier</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B12.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Variation du patrimoine – Entrées</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B12.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Variation du patrimoine – Sorties</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" style="layout-grid-mode:char"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B13</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Opérations liées aux cessions</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B14</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des travaux en régie</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">C. États annexés budgétaires</span></i></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Équilibre budgétaire - dépenses</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Équilibre budgétaire - recettes</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C2.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Situation des autorisations de programme</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C2.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Situation des autorisations d’engagement</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">D. Autres éléments d’information</span></i></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des recettes grevées d'une affectation spéciale</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D2.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt;color:black">Liste des services assujettis à la TVA et non érigés en budget annexe</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D2.2.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt;color:black">Services assujettis à la TVA – vue d’ensemble</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D3.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Services ferroviaires régionaux des voyageurs (SRV) - Volet 1 : Budget</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D3.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">SRV - Volet 2 : Compte d'exploitation</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D3.3</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">SRV - Volet 3 : Patrimoine</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D4.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Variation du patrimoine (article L. 300-5 du code de l'urbanisme) – Entrées</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D4.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Variation du patrimoine (article L. 300-5 du code de l'urbanisme) – Sorties</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D5</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Gestion des fonds européens</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D6</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Emploi des crédits communautaires dans le cadre de la subvention globale</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D7</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Actions de formation des élus</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D8</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État relatif aux ressources et dépenses de la formation professionnelle des jeunes</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D9</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Compte d'emploi du fonds commun des services d'hébergement</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D10</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Identification des flux croisés</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D11.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt;color:black">États de la répartition de la TEOM – investissement</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D11.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt;color:black">États de la répartition de la TEOM – fonctionnement</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt;color:black">V. Arrêté et signatures</span></b></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm72" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link192">AARRESIG</xsl:variable><xsl:variable name ="Link193" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link194" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('Arrêté', ' ', 'et', ' ', 'signatures')" /><xsl:with-param name="Param_2" select="$Link192" /><xsl:with-param name="Param_3" select="$Link193" /><xsl:with-param name="Param_4" select="$Link194" /></xsl:call-template></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur / Comptable</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_32994_nature &gt; 0"><xsl:value-of select="$p_32994_nature" /></xsl:if></span></p>
                        </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab13"></xsl:with-param></xsl:call-template>
               </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab11"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" align="center" style="text-align:center;punctuation-wrap:simple"><span style="font-size:8.0pt"> </span></p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
            function scrollToElementId(elementId) {
            document.getElementById(elementId).scrollIntoView();
            }
        </script>
</html></xsl:template></xsl:stylesheet>